void setup() {              // Über den Befehl pinMode werden die einzelnen Pins im Setup als Aus- bzw. Eingänge definiert.
  pinMode(11, OUTPUT);      // Pin 11 ist verbunden mit der roten LED der Hauptampel (Hauptampel_rot)
  pinMode(10, OUTPUT);      // Pin 10 ist verbunden mit der gelben LED der Hauptampel (Hauptampel_gelb)
  pinMode(9, OUTPUT);       // Hauptampel_grün
  
  pinMode(13, OUTPUT);      // Fussgänger_rot 
  pinMode(12, OUTPUT);      // Fussgänger_grün
  

  pinMode(2, INPUT);        // Der Druckschalter (Taster) ist mit Pin 2 verbunden (wird für eine spätere Aufgabe benötigt)
  digitalWrite(2, HIGH);    // Pin 2 wird auf HIGH gesetzt, das heisst, dort liegen nun 5V an

  Serial.begin(9600);       // Hier wird der serielle Monitor initialisiert. Die Geschwindigkeit wird auf 9600 Signaländerungen/Sekunde gesetzt. In der Arduino-IDE muss der gleiche Wert eingestellt sein.

}

void loop() {
  digitalWrite (11, HIGH);  // Setzt den PIN 11 auf HIGH (5V) und schaltet damit die rote LED an
  digitalWrite (10, HIGH);  // GELB an
  digitalWrite (9, HIGH);   // GRÜN an
  delay (1000);             // Warten für 1000 millisekunden ( = 1 Sekunde)
  
  digitalWrite (11, LOW);   // Setzt den PIN 11 auf LOW (0V) und schaltet damit die rote LED aus
  digitalWrite (10, LOW);   // GELB aus
  digitalWrite (9, LOW);    // GRÜN aus
  delay (1000);

  Serial.print ("Hallo Welt");  // Hallo Welt wird auf den seriellen Monitor geschrieben. Andere Texte gehen auch.

}




/*  P2_Ampelschaltung_01.10.2018
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************

    1   VORBEREITUNG - Laden Sie dieses Programm unverändert auf den Aruino hoch. Wenn alles geklappt hat, blinken die LEDs der Ampel. 

  
    2   VERKEHRSAMPEL - Programmieren Sie die Hauptampel so, dass sie folgende Signalfolge wiedergibt: 

        rot --> rot + gelb --> grün --> gelb --> rot


    3   FUSSGAENGERAMPEL -  Binden Sie nun zusätzlich die Fussgängerampel mit ein und passen Sie beide Signalfolgen aufeinander an. 
        Die Fussgänger haben erst grün, wenn die Hauptampel rot anzeigt und umgekehrt.


    4   ANFORDERUNGSKONTAKT I - Binden Sie den Druckschalter als Anforderungskontakt an der Fußgängerampel ein. 
        Wenn der Anforderungskontakt gedrückt wird, wechselt die Verkehrsampel von grün über gelb auf rot und schaltet anschließend die Fußgängerampel auf grün.

        Der Programmcode für eine einfache Abfrage eines Schalters ist weiter unten im Quellcode. Analysieren Sie die Programmfunktionen und bauen Sie die Programmcodes ein.


    5   SIGNAL KOMMT - Lassen Sie den Arduino die Meldung "Signal kommt" auf den Seriellen Monitor schreiben.


    6   ANFORDERUNGSKONTAKT II (EXPERTENAUFGABE) - Geben Sie auf dem seriellen Monitor aus, wie oft der Anforderungskontakt gedrückt wurde.


    7   ANFORDERUNGSKONTAKT III (EXPERTENAUFGABE) - Verwenden Sie Interrupts (= Unterbrechungsroutinen), um den Anforderungskontakt abzufragen.

        

    **********************************************************  
      PROGRAMMCODE FÜR TEILAUFGABEN
    **********************************************************

    4   ANFORDERUNGSKONTAKT I - PROGRAMMCODE

    Fügen Sie folgende Befehle an geeigneter Stelle innerhalb(!) der Loop ein und passen Sie den Programmcode an

    
      if (digitalRead (2) == LOW) {     // Wenn Pin 2 LOW ist, dann werden die Befehle in den geschweiften Klammern ausgeführt.
                
        digitalWrite  (12, HIGH);       // Setze PIN 12 auf HIGH und schalte damit Fussgänger_grün
        delay (500);
        digitalWrite (12, LOW);         // Fussgänger_grün aus
      
        }                               // Ende der if-Schleife
  
      else {                            // Wenn die Bedingungen für die if-Schleife (in diesem Fall LOW auf PIN 2) nicht zutreffen wir statt dessen folgendes gemacht...
                                        // hier könnte noch Programmcode stehen
        }                               // Ende der else-Schleife


    
    
    **********************************************************
    LÖSUNGSHINWEISE
    **********************************************************

    4   ANFORDERUNGSKONTAKT I - LÖSUNGSHINWEISE

    - Sie müssen nicht alle Kommentare in den Quellcodes behalten, löschen Sie unnötige einfach heraus für mehr Übersichtlichkeit.
    - Was kommt in die else-Schleife? Was zeigt die Ampel an, wenn der Taster nicht gedrückt wird? Grün für die Autofahrer, rot für die Fussgänger. 
    - Was kommt in die if-Schleife? Sobald der Taster gedrückt wird, ändert die Ampel ihre Anzeige von Grün auf ...  Dieser Signalverlauf kommt in die if-Schleife. 
    

    5   SIGNAL KOMMT - 

    Die Meldung „Signal kommt“ verschwindet an einer Ampel auch wieder, eine Ausgabe auf dem seriellen Monitor kann allerdings nicht gelöscht werden. Sie müssen daher, wenn der Taster nicht gedrückt wurde, eine Mitteilung wie z.B. „Signal anfordern!“ auf den seriellen Monitor schreiben.


*/
